IF EXISTS ( SELECT * 
            FROM   sysobjects 
            WHERE  id = object_id(N'CPJ_Clientes_ResumenCta') 
                   and OBJECTPROPERTY(id, N'IsProcedure') = 1 )
BEGIN
    DROP PROCEDURE CPJ_Clientes_ResumenCta
END
GO

CREATE PROCEDURE CPJ_Clientes_ResumenCta @pJsonRecibido VARCHAR(8000)
AS 
SET NOCOUNT ON
/*Parametros*/

DECLARE 	@pFechaDesde			DATETIME,
			@pFechaHasta			DATETIME,
			@pId_Unid_Negocio       VARCHAR(10),
			@pFiltrar_con_saldo     TINYINT,
			@pClientes_activos      TINYINT

SET @pId_Unid_Negocio			= ISNULL(CONVERT(VARCHAR(10), dbo.CF_JSON_VALUE(@pJsonRecibido,'Id_Unid_Negocio')),'')
SET @pFechaDesde				= ISNULL(CONVERT(DATETIME, dbo.CF_JSON_VALUE(@pJsonRecibido,'FechaDesde')),GETDATE())
SET @pFechaHasta				= ISNULL(CONVERT(DATETIME, dbo.CF_JSON_VALUE(@pJsonRecibido,'FechaHasta')),GETDATE())
SET @pFiltrar_con_saldo			= ISNULL(CONVERT(TINYINT, dbo.CF_JSON_VALUE(@pJsonRecibido,'Filtrar_con_saldo')),0)
SET @pClientes_activos			= ISNULL(CONVERT(TINYINT, dbo.CF_JSON_VALUE(@pJsonRecibido,'Clientes_activos')),0)

/*Declaracion Variables Locales*/

DECLARE @Mensaje			VARCHAR(100)
		,@UltError			INT
		,@Id_Trans			INT
		,@Id_Cliente		INT
		,@Importe			DECIMAL(16,2)
		,@Email_Cob			VARCHAR(256)
		,@Id_Trans_Rec		INT
		,@CursorOpen        INT
		,@Flag_Cbte_Tipo	SMALLINT
		,@Periodo           DATE 
		,@Id_sucursal	    SMALLINT
		,@Venta_Total       DECIMAL(16,2)

					
BEGIN 


    SELECT ID_UNID_NEGOCIO INTO #UN FROM Empresas_Unid_Negocios

	IF @pId_Unid_Negocio <> ''
       DELETE #UN WHERE ID_UNID_NEGOCIO <> @pId_Unid_Negocio 


	CREATE TABLE #ACTIVO (ACTIVO TINYINT)
    INSERT INTO #ACTIVO (ACTIVO) VALUES (1)

	IF @pClientes_activos <> 1
	  INSERT INTO #ACTIVO (ACTIVO) VALUES (0)


		Select c.Id_Cliente, c.Razon_Social, CAST(sum(isnull(f.Imp_Total,0) * f.cotizacion * isnull(T.Compromete_Factura,0)) - sum(isnull(f.Imp_Total,0) * f.cotizacion * isnull(T.Compromete_Recibos,0)) AS DECIMAL(14,2)) AS Saldo
		Into #Resumen_Cta
		 from Cbtes_Tipos T, clientes c, cbtes F, #UN U, #ACTIVO A
		 where C.id_cliente = f.id_cliente
		 AND A.ACTIVO = C.ACTIVO
		 AND T.Id_Unid_Negocio = U.Id_Unid_Negocio
		 and f.id_tipo_cbte = t.id_tipo_cbte
		 and (f.Id_Cond_Pago <> 1 and t.Compromete_Factura in (1,-1) 
			  or t.Compromete_recibos in (1,-1))
		 and f.id_estado_cbte not in (0,3)
		 AND F.FECHA < dateadd(dd,1,@pFechaHasta)
		 group by c.id_cliente, c.razon_social 

		IF @pFiltrar_con_saldo = 1
		      DELETE #Resumen_Cta WHERE ABS(SALDO) < 1


		alter table #Resumen_Cta add Sdo_Ant decimal(16,2),Debe decimal(16,2), Haber decimal(16,2)

		update #Resumen_Cta set Debe=0,Haber=0,Sdo_Ant=0

		Select c.Id_Cliente, CAST(sum(isnull(f.Imp_Total,0) * f.cotizacion * isnull(T.Compromete_Factura,0)) - sum(isnull(f.Imp_Total,0) * f.cotizacion * isnull(T.Compromete_Recibos,0)) AS DECIMAL(14,2)) AS Sdo_Ant
		Into #Resumen_Sdo_Ant
		From Cbtes_Tipos T, clientes c, cbtes F, #UN U, #ACTIVO A
		Where c.id_cliente = f.id_cliente
	   	 AND A.ACTIVO = C.ACTIVO
		 AND T.Id_Unid_Negocio = U.Id_Unid_Negocio
		 and f.id_tipo_cbte = t.id_tipo_cbte
		 and (f.Id_Cond_Pago <> 1 and t.Compromete_Factura in (1,-1) 
			  or t.Compromete_recibos in (1,-1))
		 and f.id_estado_cbte not in (0,3)
		 AND F.FECHA < @pFechaDesde 
		 group by c.id_cliente 


		select f.id_cliente,(sum(isnull(f.Imp_Total,0) * f.cotizacion * isnull(T.Compromete_Factura,0))) as debe
		 into #Resumen_Debe
		 from Cbtes_Tipos T, cbtes F, #Resumen_Cta R, #UN U
		 where r.id_cliente = f.id_cliente
		 AND T.Id_Unid_Negocio = U.Id_Unid_Negocio
		and f.id_tipo_cbte = t.id_tipo_cbte
		and f.Id_Cond_Pago <> 1 and t.Compromete_Factura in (1) 
		and f.id_estado_cbte not in (0,3)
	    AND F.FECHA >= @pFechaDesde 
		AND F.FECHA < dateadd(dd,1,@pFechaHasta)
		group by f.id_cliente

		select f.id_cliente,(sum(isnull(f.Imp_Total,0) * f.cotizacion * isnull(T.Compromete_Factura,0))) as Haber
		 into #Resumen_Haber
		 from Cbtes_Tipos T, cbtes F, #Resumen_Cta R, #UN U
		 where r.id_cliente = f.id_cliente
		 AND T.Id_Unid_Negocio = U.Id_Unid_Negocio
		and f.id_tipo_cbte = t.id_tipo_cbte
		and f.Id_Cond_Pago <> 1 and t.Compromete_Factura in (-1) 
		and f.id_estado_cbte not in (0,3)
		AND F.FECHA >= @pFechaDesde 
		AND F.FECHA < dateadd(dd,1,@pFechaHasta)
		group by f.id_cliente
 
		Select F.Id_Cliente, sum(isnull(f.Imp_Total,0) * f.cotizacion * isnull(T.Compromete_Recibos,0)) as Recibos
		 into #Resumen_Rec
		 from Cbtes_Tipos T, cbtes F, #Resumen_Cta R, #UN U
		 where r.id_cliente = f.id_cliente
		 AND T.Id_Unid_Negocio = U.Id_Unid_Negocio
		and f.id_tipo_cbte = t.id_tipo_cbte
		and t.Compromete_Recibos in (1,-1) 
		and f.id_estado_cbte not in (0,3)
		AND F.FECHA >= @pFechaDesde 
		AND F.FECHA < dateadd(dd,1,@pFechaHasta)
		group by f.id_cliente

		update #Resumen_Cta set Debe = D.Debe
		from #Resumen_Cta C,#Resumen_Debe D 
		Where C.Id_Cliente = D.Id_Cliente

		update #Resumen_Cta set  Haber = (H.Haber*-1) 
		from #Resumen_Cta C, #Resumen_Haber H
		Where C.Id_Cliente = H.Id_Cliente

		update #Resumen_Cta set  Haber = Haber + R.Recibos
		from #Resumen_Cta C, #Resumen_Rec R
		Where C.Id_Cliente = R.Id_Cliente

		update #Resumen_Cta set  Sdo_Ant = S.Sdo_Ant
		from #Resumen_Cta C, #Resumen_Sdo_Ant S
		Where C.Id_Cliente = S.Id_Cliente

	
		SELECT * FROM #Resumen_Cta


		DROP TABLE #Resumen_Cta
		DROP TABLE #Resumen_DEBE
        DROP TABLE #Resumen_HABER
        DROP TABLE #Resumen_REC
        DROP TABLE #UN
		DROP TABLE #ACTIVO
END

/*

EXEC dbo.CPJ_Clientes_ResumenCta   '{
			"FechaDesde":"20210801",
			"FechaHasta":"20210930",
		    "Filtrar_con_saldo":"1",
			"Clientes_activos":"1",
			"Id_Unid_Negocio":""
		}'

*/